/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.modularstorage.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.client.GuiTools;
import mcjty.lib.container.BaseSlot;
import mcjty.lib.container.GhostOutputSlot;
import mcjty.lib.container.GhostSlot;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.WindowManager;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.AbstractWidget;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.ImageLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsstorage.craftinggrid.CraftingGridProvider;
import mcjty.rftoolsstorage.craftinggrid.GuiCraftingGrid;
import mcjty.rftoolsstorage.modules.modularstorage.ModularStorageConfiguration;
import mcjty.rftoolsstorage.modules.modularstorage.ModularStorageModule;
import mcjty.rftoolsstorage.modules.modularstorage.blocks.ModularStorageContainer;
import mcjty.rftoolsstorage.modules.modularstorage.blocks.ModularStorageTileEntity;
import mcjty.rftoolsstorage.setup.CommandHandler;
import mcjty.rftoolsstorage.setup.RFToolsStorageMessages;
import mcjty.rftoolsstorage.storage.modules.DefaultTypeModule;
import mcjty.rftoolsstorage.storage.modules.TypeModule;
import mcjty.rftoolsstorage.storage.sorters.ItemSorter;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class GuiModularStorage
extends GenericGuiContainer<ModularStorageTileEntity, ModularStorageContainer> {
    public static final int STORAGE_WIDTH = 256;
    public static final String VIEW_LIST = "list";
    public static final String VIEW_COLUMNS = "columns";
    public static final String VIEW_ICONS = "icons";
    private TypeModule typeModule;
    private static final ResourceLocation iconLocationTop = new ResourceLocation("rftoolsstorage", "textures/gui/modularstoragetop.png");
    private static final ResourceLocation iconLocation = new ResourceLocation("rftoolsstorage", "textures/gui/modularstorage.png");
    private static final ResourceLocation guiElements = new ResourceLocation("rftoolsbase", "textures/gui/guielements.png");
    private WidgetList itemList;
    private TextField filter;
    private ImageChoiceLabel viewMode;
    private ImageChoiceLabel sortMode;
    private ImageChoiceLabel groupMode;
    private Label amountLabel;
    private ToggleButton lockButton;
    private Button cycleButton;
    private Button compactButton;
    private Label warningLabel;
    private final GuiCraftingGrid craftingGrid = new GuiCraftingGrid();

    public GuiModularStorage(ModularStorageTileEntity tileEntity, ModularStorageContainer container, Inventory inventory) {
        super((GenericTileEntity)tileEntity, (AbstractContainerMenu)container, inventory, ((BaseBlock)ModularStorageModule.MODULAR_STORAGE.get()).getManualEntry());
        this.f_97726_ = 256;
        double height = Minecraft.m_91087_().m_91268_().m_85446_();
        this.f_97727_ = height > 510.0 ? (Integer)ModularStorageConfiguration.height3.get() : (height > 340.0 ? ((Integer)ModularStorageConfiguration.height2.get()).intValue() : ((Integer)ModularStorageConfiguration.height1.get()).intValue());
    }

    public static void register() {
        GuiModularStorage.register((MenuType)((MenuType)ModularStorageModule.CONTAINER_MODULAR_STORAGE.get()), GuiModularStorage::new);
    }

    public void m_7856_() {
        super.m_7856_();
        this.itemList = ((WidgetList)((WidgetList)Widgets.list((int)5, (int)3, (int)235, (int)(this.f_97727_ - 89)).name("items")).noSelectionMode(true).userObject((Object)-1)).leftMargin(0).rowheight(-1);
        Slider slider = ((Slider)Widgets.slider((int)241, (int)3, (int)11, (int)(this.f_97727_ - 89)).desiredWidth(11)).vertical().scrollableName("items");
        this.warningLabel = Widgets.label((int)20, (int)20, (int)200, (int)20, (String)"Lock the storage to access the items!");
        this.lockButton = (ToggleButton)((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().hint(5, this.f_97727_ - 23 - 18, 16, 16)).text("L")).name("lock")).event(this::updateSettings).tooltips(new String[]{"Lock/unlock the module slots"});
        this.cycleButton = (Button)((Button)((Button)Widgets.button((int)5, (int)(this.f_97727_ - 23), (int)16, (int)16, (String)"C").name("cycle")).channel("cycle")).tooltips(new String[]{"Cycle to the next storage module"});
        Panel modePanel = this.setupModePanel();
        Panel toplevel = (Panel)Widgets.positional().children(new Widget[]{this.itemList, slider, modePanel, this.lockButton, this.cycleButton, this.warningLabel});
        toplevel.setBackgrounds(iconLocationTop, iconLocation);
        toplevel.setBackgroundLayout(false, this.f_97727_ - (Integer)ModularStorageConfiguration.height1.get() + 2);
        if (this.tileEntity == null) {
            ImageLabel hideLabel = new ImageLabel();
            hideLabel.hint(4, this.f_97727_ - 26 - 54, 20, 55);
            hideLabel.image(guiElements, 32, 32);
            toplevel.children(new Widget[]{hideLabel});
        }
        toplevel.bounds(this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_);
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
        this.window.event("cycle", (source, params) -> this.cycleStorage());
        this.window.event("compact", (source, params) -> this.compact());
        if (((Boolean)ModularStorageConfiguration.autofocusSearch.get()).booleanValue()) {
            this.window.setTextFocus((Widget)this.filter);
        }
        CraftingGridProvider provider = null;
        BlockPos pos = null;
        if (this.tileEntity == null) {
            throw new RuntimeException("Should not happen!");
        }
        provider = (CraftingGridProvider)this.tileEntity;
        pos = ((ModularStorageTileEntity)this.tileEntity).m_58899_();
        this.craftingGrid.initGui(RFToolsStorageMessages.INSTANCE, this.f_96541_, this, pos, (ResourceKey<Level>)((ModularStorageTileEntity)this.tileEntity).getDimension(), provider, this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_);
        this.sendServerCommand(RFToolsStorageMessages.INSTANCE, "rftoolsstorage", "requestGridSync", TypedMap.builder().put(CommandHandler.PARAM_POS, (Object)pos).put(CommandHandler.PARAM_DIMENSION, (Object)((ModularStorageTileEntity)this.tileEntity).getDimension()).build());
    }

    protected void registerWindows(WindowManager mgr) {
        super.registerWindows(mgr);
        mgr.addWindow(this.craftingGrid.getWindow());
    }

    private Panel setupModePanel() {
        this.filter = ((TextField)Widgets.textfield((int)3, (int)3, (int)57, (int)13).tooltips(new String[]{"Name based filter for items"})).event(newText -> this.updateSettings());
        this.viewMode = ((ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel().hint(4, 19, 16, 16)).tooltips(new String[]{"Control how items are shown", "in the view"})).event(newChoice -> this.updateSettings());
        this.viewMode.choice(VIEW_LIST, "Items are shown in a list view", guiElements, 144, 16);
        this.viewMode.choice(VIEW_COLUMNS, "Items are shown in columns", guiElements, 160, 16);
        this.viewMode.choice(VIEW_ICONS, "Items are shown with icons", guiElements, 176, 16);
        this.updateTypeModule();
        this.sortMode = ((ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel().hint(23, 19, 16, 16)).tooltips(new String[]{"Control how items are sorted", "in the view"})).event(newChoice -> this.updateSettings());
        for (ItemSorter sorter : this.typeModule.getSorters()) {
            this.sortMode.choice(sorter.getName(), sorter.getTooltip(), guiElements, sorter.getU(), sorter.getV());
        }
        this.groupMode = ((ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel().hint(42, 19, 16, 16)).tooltips(new String[]{"If enabled it will show groups", "based on sorting criterium"})).event(newChoice -> this.updateSettings());
        this.groupMode.choice("Off", "Don't show groups", guiElements, 208, 0);
        this.groupMode.choice("On", "Show groups", guiElements, 224, 0);
        this.amountLabel = (Label)((Label)Widgets.label((int)16, (int)40, (int)66, (int)12, (String)"?/?").horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).tooltips(new String[]{"Amount of stacks / maximum amount"});
        this.compactButton = (Button)((Button)((Button)Widgets.button((int)4, (int)39, (int)12, (int)12, (String)"z").name("compact")).channel("compact")).tooltips(new String[]{"Compact equal stacks"});
        if (this.tileEntity != null) {
            this.filter.text((Boolean)ModularStorageConfiguration.clearSearchOnOpen.get() != false ? "" : ((ModularStorageTileEntity)this.tileEntity).getFilter());
            this.setViewMode(((ModularStorageTileEntity)this.tileEntity).getViewMode());
            this.setSortMode(((ModularStorageTileEntity)this.tileEntity).getSortMode());
            this.groupMode.setCurrentChoice(((ModularStorageTileEntity)this.tileEntity).isGroupMode() ? 1 : 0);
            this.lockButton.pressed(((ModularStorageTileEntity)this.tileEntity).isLocked());
            this.warningLabel.visible(!((ModularStorageTileEntity)this.tileEntity).isLocked());
            this.itemList.visible(((ModularStorageTileEntity)this.tileEntity).isLocked());
        } else {
            ItemStack heldItem = this.f_96541_.f_91074_.m_21120_(InteractionHand.MAIN_HAND);
            if (!heldItem.m_41619_() && heldItem.m_41782_()) {
                CompoundTag tagCompound = heldItem.m_41783_();
                this.filter.text((Boolean)ModularStorageConfiguration.clearSearchOnOpen.get() != false ? "" : tagCompound.m_128461_("filter"));
                this.setViewMode(tagCompound.m_128461_("viewMode"));
                this.setSortMode(tagCompound.m_128461_("sortMode"));
                this.groupMode.setCurrentChoice(tagCompound.m_128471_("groupMode") ? 1 : 0);
            }
        }
        return (Panel)((Panel)((Panel)((Panel)Widgets.positional().hint(24, this.f_97727_ - 80, 64, 77)).filledRectThickness(-2)).filledBackground(StyleConfig.colorListBackground)).children(new Widget[]{this.filter, this.viewMode, this.sortMode, this.groupMode, this.amountLabel, this.compactButton});
    }

    private void setSortMode(String sortMode) {
        int idx = this.sortMode.findChoice(sortMode);
        if (idx == -1) {
            this.sortMode.setCurrentChoice(0);
        } else {
            this.sortMode.setCurrentChoice(idx);
        }
    }

    private void setViewMode(String viewMode) {
        int idx = this.viewMode.findChoice(viewMode);
        if (idx == -1) {
            this.viewMode.setCurrentChoice(VIEW_LIST);
        } else {
            this.viewMode.setCurrentChoice(idx);
        }
    }

    private void cycleStorage() {
        if (this.tileEntity != null) {
            this.window.sendServerCommand(RFToolsStorageMessages.INSTANCE, ModularStorageTileEntity.CMD_CYCLE, TypedMap.EMPTY);
        } else {
            this.sendServerCommand(RFToolsStorageMessages.INSTANCE, "rftoolsstorage", "cycleStorage");
        }
    }

    private void compact() {
        if (this.tileEntity != null) {
            this.window.sendServerCommand(RFToolsStorageMessages.INSTANCE, ModularStorageTileEntity.CMD_COMPACT, TypedMap.EMPTY);
        } else {
            this.sendServerCommand(RFToolsStorageMessages.INSTANCE, "rftoolsstorage", "compact");
        }
    }

    private void updateSettings() {
        if (this.tileEntity != null) {
            ((ModularStorageTileEntity)this.tileEntity).setSortMode(this.sortMode.getCurrentChoice());
            ((ModularStorageTileEntity)this.tileEntity).setViewMode(this.viewMode.getCurrentChoice());
            ((ModularStorageTileEntity)this.tileEntity).setFilter(this.filter.getText());
            ((ModularStorageTileEntity)this.tileEntity).setGroupMode(this.groupMode.getCurrentChoiceIndex() == 1);
            ((ModularStorageTileEntity)this.tileEntity).setLocked(this.lockButton.isPressed());
            this.warningLabel.visible(!((ModularStorageTileEntity)this.tileEntity).isLocked());
            this.itemList.visible(((ModularStorageTileEntity)this.tileEntity).isLocked());
            this.sendServerCommandTyped(RFToolsStorageMessages.INSTANCE, ModularStorageTileEntity.CMD_SETTINGS, TypedMap.builder().put(ModularStorageTileEntity.PARAM_SORTMODE, (Object)this.sortMode.getCurrentChoice()).put(ModularStorageTileEntity.PARAM_VIEWMODE, (Object)this.viewMode.getCurrentChoice()).put(ModularStorageTileEntity.PARAM_FILTER, (Object)this.filter.getText()).put(ModularStorageTileEntity.PARAM_GROUPMODE, (Object)(this.groupMode.getCurrentChoiceIndex() == 1 ? 1 : 0)).put(ModularStorageTileEntity.PARAM_LOCKED, (Object)this.lockButton.isPressed()).build());
        }
    }

    private Slot findEmptySlot() {
        for (Slot slot : ((ModularStorageContainer)this.f_97732_).f_38839_) {
            if (this.tileEntity != null && !(slot instanceof BaseSlot) || slot.m_6657_() && slot.m_7993_().m_41613_() != 0) continue;
            return slot;
        }
        return null;
    }

    public boolean m_97774_(@Nonnull Slot slotIn, double x, double y) {
        if (slotIn instanceof BaseSlot && ((BaseSlot)slotIn).getTe() instanceof ModularStorageTileEntity) {
            Widget widget = this.window.getToplevel().getWidgetAtPosition(x, y);
            if (widget instanceof BlockRender) {
                Object userObject = widget.getUserObject();
                if (userObject instanceof Integer) {
                    Integer slotIndex = (Integer)userObject;
                    return slotIndex == slotIn.f_40219_;
                }
            } else {
                return super.m_97774_(slotIn, x, y);
            }
            return false;
        }
        return super.m_97774_(slotIn, x, y);
    }

    public Slot m_97744_(double x, double y) {
        Object userObject;
        Widget widget = this.window.getToplevel().getWidgetAtPosition(x, y);
        if (widget != null && (userObject = widget.getUserObject()) instanceof Integer) {
            Integer slotIndex = (Integer)userObject;
            if (slotIndex != -1) {
                return ((ModularStorageContainer)this.f_97732_).m_38853_(slotIndex);
            }
            return this.findEmptySlot();
        }
        return super.m_97744_(x, y);
    }

    private void dumpClasses(String name, Object o) {
        Logging.log((String)(name + ":" + o.getClass().getCanonicalName()));
        Class<?>[] classes = o.getClass().getClasses();
        for (Class<?> a : classes) {
            Logging.log((String)("        " + a.getCanonicalName()));
        }
        Logging.log((String)("        Super:" + o.getClass().getGenericSuperclass()));
        for (Type type : o.getClass().getGenericInterfaces()) {
            Logging.log((String)("        type:" + type.getClass().getCanonicalName()));
        }
    }

    public boolean m_6375_(double x, double y, int button) {
        Slot slot;
        boolean r = super.m_6375_(x, y, button);
        if (button == 1 && (slot = this.m_97744_(x, y)) instanceof GhostOutputSlot) {
            if (this.tileEntity != null) {
                this.window.sendServerCommand(RFToolsStorageMessages.INSTANCE, ModularStorageTileEntity.CMD_CLEARGRID, TypedMap.EMPTY);
            } else {
                this.sendServerCommand(RFToolsStorageMessages.INSTANCE, "rftoolsstorage", "clearGrid");
            }
        }
        return r;
    }

    private void updateList() {
        int spacing;
        int labelWidth;
        int numcolumns;
        this.itemList.removeChildren();
        if (this.tileEntity != null && !((ModularStorageContainer)this.f_97732_).m_38853_(0).m_6657_()) {
            this.amountLabel.text("(empty)");
            this.compactButton.enabled(false);
            this.cycleButton.enabled(false);
            return;
        }
        this.cycleButton.enabled(this.isTabletWithRemote() || this.isRemote());
        String filterText = this.filter.getText().toLowerCase().trim();
        String view = this.viewMode.getCurrentChoice();
        if (VIEW_LIST.equals(view)) {
            numcolumns = 1;
            labelWidth = 210;
            spacing = 5;
        } else if (VIEW_COLUMNS.equals(view)) {
            numcolumns = 2;
            labelWidth = 86;
            spacing = 5;
        } else {
            numcolumns = 12;
            labelWidth = 0;
            spacing = 3;
        }
        AtomicInteger max = new AtomicInteger();
        ArrayList<Pair<ItemStack, Integer>> items = new ArrayList<Pair<ItemStack, Integer>>();
        if (this.tileEntity != null) {
            ((ModularStorageTileEntity)this.tileEntity).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack stack = handler.getStackInSlot(i);
                    if (stack.m_41619_()) continue;
                    String displayName = stack.m_41786_().getString();
                    if (!filterText.isEmpty() && !displayName.toLowerCase().contains(filterText)) continue;
                    items.add(Pair.of((Object)stack, (Object)(i + 3)));
                }
                max.set(handler.getSlots());
            });
        }
        this.amountLabel.text(items.size() + "/" + max);
        this.compactButton.enabled(max.get() > 0);
        int sort = this.getCurrentSortMode();
        boolean dogroups = this.groupMode.getCurrentChoiceIndex() == 1;
        ItemSorter itemSorter = this.typeModule.getSorters().get(sort);
        items.sort(itemSorter.getComparator());
        Pair<Panel, Integer> currentPos = MutablePair.of(null, (Object)0);
        Pair prevItem = null;
        for (Pair pair : items) {
            currentPos = this.addItemToList((ItemStack)pair.getKey(), this.itemList, currentPos, numcolumns, labelWidth, spacing, (Integer)pair.getValue(), dogroups && (prevItem == null || !itemSorter.isSameGroup(prevItem, (Pair<ItemStack, Integer>)pair)), itemSorter.getGroupName((Pair<ItemStack, Integer>)pair));
            prevItem = pair;
        }
        int newfirst = -1;
        if (this.itemList.getCountSelected() == 0) {
            if (this.itemList.getBounds() != null) {
                this.itemList.setFirstSelected(0);
                newfirst = this.itemList.getChildCount() - this.itemList.getCountSelected();
                if (newfirst < 0) {
                    newfirst = 0;
                }
            }
        } else if (this.itemList.getFirstSelected() > this.itemList.getChildCount() - this.itemList.getCountSelected()) {
            newfirst = this.itemList.getChildCount() - this.itemList.getCountSelected();
        }
        if (newfirst >= 0) {
            this.itemList.setFirstSelected(newfirst);
        }
    }

    private boolean isRemote() {
        return false;
    }

    private boolean isTabletWithRemote() {
        if (this.tileEntity != null) {
            return false;
        }
        ItemStack heldItem = this.f_96541_.f_91074_.m_21120_(InteractionHand.MAIN_HAND);
        if (!heldItem.m_41619_() && heldItem.m_41782_()) {
            int storageType = heldItem.m_41783_().m_128451_("childDamage");
            return storageType == 6;
        }
        return false;
    }

    private int getCurrentSortMode() {
        this.updateTypeModule();
        String sortName = this.sortMode.getCurrentChoice();
        this.sortMode.clear();
        for (ItemSorter sorter : this.typeModule.getSorters()) {
            this.sortMode.choice(sorter.getName(), sorter.getTooltip(), guiElements, sorter.getU(), sorter.getV());
        }
        int sort = this.sortMode.findChoice(sortName);
        if (sort == -1) {
            sort = 0;
        }
        this.sortMode.setCurrentChoice(sort);
        return sort;
    }

    private void updateTypeModule() {
        ItemStack typeStack;
        this.typeModule = this.tileEntity != null ? ((typeStack = ItemStack.f_41583_).m_41619_() || !(typeStack.m_41720_() instanceof TypeModule) ? new DefaultTypeModule() : (TypeModule)typeStack.m_41720_()) : new DefaultTypeModule();
    }

    private Pair<Panel, Integer> addItemToList(ItemStack stack, WidgetList itemList, Pair<Panel, Integer> currentPos, int numcolumns, int labelWidth, int spacing, int slot, boolean newgroup, String groupName) {
        Panel panel = (Panel)currentPos.getKey();
        if (panel == null || (Integer)currentPos.getValue() >= numcolumns || newgroup && groupName != null) {
            if (newgroup && groupName != null) {
                AbstractWidget groupLabel = ((Label)((Label)((Label)((Label)((Label)Widgets.label((String)groupName).color(((Integer)ModularStorageConfiguration.groupForeground.get()).intValue())).color(StyleConfig.colorTextInListNormal)).horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).filledBackground(((Integer)ModularStorageConfiguration.groupBackground.get()).intValue())).desiredHeight(10)).desiredWidth(231);
                itemList.children(new Widget[]{((Panel)new Panel().layout((Layout)((HorizontalLayout)new HorizontalLayout().setHorizontalMargin(2)).setVerticalMargin(0)).desiredHeight(10)).children(new Widget[]{groupLabel})});
            }
            panel = (Panel)((Panel)((Panel)Widgets.horizontal((int)5, (int)spacing).desiredHeight(12)).userObject((Object)-1)).desiredHeight(16);
            currentPos = MutablePair.of((Object)panel, (Object)0);
            itemList.children(new Widget[]{panel});
        }
        BlockRender blockRender = ((BlockRender)new BlockRender().renderItem((Object)stack).userObject((Object)slot)).offsetX(-1).offsetY(-1);
        panel.children(new Widget[]{blockRender});
        if (labelWidth > 0) {
            String displayName = labelWidth > 100 ? this.typeModule.getLongLabel(stack) : this.typeModule.getShortLabel(stack);
            AbstractWidget label = ((Label)((Label)((Label)Widgets.label((String)displayName).color(StyleConfig.colorTextInListNormal)).horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).desiredWidth(labelWidth)).userObject((Object)new Integer(-1));
            panel.children(new Widget[]{label});
        }
        currentPos.setValue((Object)((Integer)currentPos.getValue() + 1));
        return currentPos;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean rc = false;
        if (!this.window.keyTyped(keyCode, scanCode)) {
            if (keyCode >= 49 && keyCode <= 57) {
                return true;
            }
            rc = super.m_7933_(keyCode, scanCode, modifiers);
        }
        return rc;
    }

    protected void m_7286_(@Nonnull PoseStack matrixStack, float v, int i, int i2) {
        this.updateList();
        if (this.tileEntity != null) {
            this.viewMode.setCurrentChoice(((ModularStorageTileEntity)this.tileEntity).getViewMode());
            this.sortMode.setCurrentChoice(((ModularStorageTileEntity)this.tileEntity).getSortMode());
            this.groupMode.setCurrentChoice(((ModularStorageTileEntity)this.tileEntity).isGroupMode() ? 1 : 0);
            String curFilter = ((ModularStorageTileEntity)this.tileEntity).getFilter();
            if (!this.filter.getText().equals(curFilter)) {
                this.filter.text(curFilter);
            }
        }
        this.drawWindow(matrixStack);
    }

    protected void m_7025_(@Nonnull PoseStack matrixStack, int x, int y) {
        Slot slot = this.m_97744_(x, y);
        if (slot instanceof SlotItemHandler && !(slot instanceof BaseSlot) && !(slot instanceof GhostOutputSlot) && !(slot instanceof GhostSlot) && ((ModularStorageTileEntity)this.tileEntity).isLocked()) {
            this.m_96602_(matrixStack, (Component)new TextComponent("Unlock to access these slots").m_130940_(ChatFormatting.RED), x, y);
            return;
        }
        super.m_7025_(matrixStack, x, y);
    }

    protected void drawStackTooltips(PoseStack matrixStack, int mouseX, int mouseY) {
    }

    protected void m_7027_(@Nonnull PoseStack matrixStack, int mouseX, int mouseY) {
        int x = GuiTools.getRelativeX((Screen)this);
        int y = GuiTools.getRelativeY((Screen)this);
        List tooltips = this.craftingGrid.getWindow().getTooltips();
        if (tooltips != null) {
            this.drawHoveringText(matrixStack, tooltips, this.window.getTooltipItems(), x - this.f_97735_, y - this.f_97736_, this.f_96541_.f_91062_);
        }
        if (((ModularStorageTileEntity)this.tileEntity).isLocked()) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)guiElements);
            int offset = 300;
            GuiModularStorage.m_93143_((PoseStack)matrixStack, (int)5, (int)(this.f_97727_ - 79), (int)offset, (float)96.0f, (float)96.0f, (int)16, (int)16, (int)256, (int)256);
            GuiModularStorage.m_93143_((PoseStack)matrixStack, (int)5, (int)(this.f_97727_ - 61), (int)offset, (float)96.0f, (float)96.0f, (int)16, (int)16, (int)256, (int)256);
        }
        super.m_7027_(matrixStack, mouseX, mouseY);
        this.warningLabel.visible(!((ModularStorageTileEntity)this.tileEntity).isLocked());
        this.itemList.visible(((ModularStorageTileEntity)this.tileEntity).isLocked());
        this.lockButton.pressed(((ModularStorageTileEntity)this.tileEntity).isLocked());
    }

    protected void drawWindow(PoseStack matrixStack) {
        super.drawWindow(matrixStack);
        this.craftingGrid.draw(matrixStack);
    }
}

